



<?php

require '../../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/compta/paiement/class/paiement.class.php';
require_once DOL_DOCUMENT_ROOT.'/compta/facture/class/facture.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/modules/facture/modules_facture.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/payments.lib.php';
if (!empty($conf->banque->enabled)) require_once DOL_DOCUMENT_ROOT.'/compta/bank/class/account.class.php';

// Load translation files required by the page
$langs->loadLangs(array('bills', 'banks', 'companies'));

$id = GETPOST('id', 'int');
$ref = GETPOST('ref', 'alpha');
$action = GETPOST('action', 'alpha');
$confirm = GETPOST('confirm', 'alpha');
$backtopage = GETPOST('backtopage', 'alpha');

// Security check
if ($user->socid) $socid = $user->socid;
// TODO ajouter regle pour restreindre acces paiement
//$result = restrictedArea($user, 'facture', $id,'');

$object = new Paiement($db);


/*
 * Actions
 */

if ($action == 'setnote' && $user->rights->facture->paiement)
{
    $db->begin();

    $object->fetch($id);
    $result = $object->update_note(GETPOST('note', 'none'));
    if ($result > 0)
    {
        $db->commit();
        $action = '';
    }
    else
    {
	    setEventMessages($object->error, $object->errors, 'errors');
        $db->rollback();
    }
}

if ($action == 'confirm_delete' && $confirm == 'yes' && $user->rights->facture->paiement)
{
	$db->begin();

	$object->fetch($id);
	$result = $object->delete();
	if ($result > 0)
	{
        $db->commit();

        if ($backtopage)
        {
        	header("Location: ".$backtopage);
        	exit;
        }
        else
        {
        	header("Location: list.php");
        	exit;
        }
	}
	else
	{
	    $langs->load("errors");
		setEventMessages($object->error, $object->errors, 'errors');
        $db->rollback();
	}
}

if ($action == 'confirm_valide' && $confirm == 'yes' && $user->rights->facture->paiement)
{
	$db->begin();

    $object->fetch($id);
	if ($object->valide($user) > 0)
	{
		$db->commit();

		// Loop on each invoice linked to this payment to rebuild PDF
		$factures = array();
		foreach ($factures as $id)
		{
			$fac = new Facture($db);
			$fac->fetch($id);

			$outputlangs = $langs;
			if (!empty($_REQUEST['lang_id']))
			{
				$outputlangs = new Translate("", $conf);
				$outputlangs->setDefaultLang($_REQUEST['lang_id']);
			}
			if (empty($conf->global->MAIN_DISABLE_PDF_AUTOUPDATE)) {
				$fac->generateDocument($fac->modelpdf, $outputlangs);
			}
		}

		header('Location: '.$_SERVER['PHP_SELF'].'?id='.$object->id);
		exit;
	}
	else
	{
	    $langs->load("errors");
		setEventMessages($object->error, $object->errors, 'errors');
		$db->rollback();
	}
}

if ($action == 'setnum_paiement' && !empty($_POST['num_paiement']))
{
	$object->fetch($id);
    $res = $object->update_num($_POST['num_paiement']);
	if ($res === 0)
	{
		setEventMessages($langs->trans('PaymentNumberUpdateSucceeded'), null, 'mesgs');
	}
	else
	{
		setEventMessages($langs->trans('PaymentNumberUpdateFailed'), null, 'errors');
	}
}

if ($action == 'setdatep' && !empty($_POST['datepday']))
{
	$object->fetch($id);
	$datepaye = dol_mktime(GETPOST('datephour', 'int'), GETPOST('datepmin', 'int'), GETPOST('datepsec', 'int'), GETPOST('datepmonth', 'int'), GETPOST('datepday', 'int'), GETPOST('datepyear', 'int'));
	$res = $object->update_date($datepaye);
	if ($res === 0)
	{
		setEventMessages($langs->trans('PaymentDateUpdateSucceeded'), null, 'mesgs');
	}
	else
	{
		setEventMessages($langs->trans('PaymentDateUpdateFailed'), null, 'errors');
	}
}


?>
<html> <div id="seccion_imprimir">

<?php

/*
 * View
 */



llxHeader('', $langs->trans("Payment"));



//print load_fiche_titre($langs->trans("SendingsArea"));

// echo("<meta http-equiv='refresh' content='30'>");
echo "<h3 style=\"text-align:left\">";
//echo date('H:i:s d-m-Y');
// echo date('H:i:s');
echo "</h3>";

    echo "<h2 style=\"text-align:center\">";
    echo 'RECIBO DE PAGO';
    echo "</h2>";


echo "<h3 style=\"text-align:left\">";
    echo 'MOTOS PLUS CORP C.A.';
	echo '<br/> ';
	echo 'TORO MOTORCYCLES GUATIRE';
	echo '<br/> ';
	echo '0424-2246968';
	 echo "</h3>";
	// echo '<br/> ';
	// echo "<h5 style=\"text-align:left\">";
	// echo 'CALLE PRINCIPAL CONJUNTO COMERCIAL MULTIDECO';
	// echo '<br/> ';
	 // echo 'GALPON 8 URB EL MARQUES GUATIRE EDO MIRANDA';
    // echo "</h5>";



$thirdpartystatic = new Societe($db);

$result = $object->fetch($id, $ref);
if ($result <= 0)
{
	dol_print_error($db, 'Payement '.$id.' not found in database');
	exit;
}

$form = new Form($db);

$head = payment_prepare_head($object);

// dol_fiche_head($head, 'payment', $langs->trans("PaymentCustomerInvoice"), -1, 'payment');

// Confirmation de la suppression du paiement
if ($action == 'delete')
{
	print $form->formconfirm($_SERVER['PHP_SELF'].'?id='.$object->id, $langs->trans("DeletePayment"), $langs->trans("ConfirmDeletePayment"), 'confirm_delete', '', 0, 2);
}

// Confirmation de la validation du paiement
if ($action == 'valide')
{
	$facid = $_GET['facid'];
	print $form->formconfirm($_SERVER['PHP_SELF'].'?id='.$object->id.'&amp;facid='.$facid, $langs->trans("ValidatePayment"), $langs->trans("ConfirmValidatePayment"), 'confirm_valide', '', 0, 2);
}

// $linkback = '<a href="'.DOL_URL_ROOT.'/compta/paiement/logo.png">'.$langs->trans("MOTOS PLUS CORP C.A.").'</a>';

dol_banner_tab($object, 'ref', $linkback, 1, 'ref', 'ref', '');


print '<div class="fichecenter">';
// print '<div class="underbanner clearboth"></div>';

print '<table class="border centpercent">'."\n";

// Date payment
print '<tr><td class="titlefield">'.$form->editfieldkey("Date", 'datep', $object->date, $object, $user->rights->facture->paiement).'</td><td>';
print $form->editfieldval("Date", 'datep', $object->date, $object, $user->rights->facture->paiement, 'datehourpicker', '', null, $langs->trans('PaymentDateUpdateSucceeded'));
print '</td></tr>';

// Payment type (VIR, LIQ, ...)
$labeltype = $langs->trans("PaymentType".$object->type_code) != ("PaymentType".$object->type_code) ? $langs->trans("PaymentType".$object->type_code) : $object->type_label;
print '<tr><td>'.$langs->trans('PaymentMode').'</td><td>'.$labeltype;
print $object->num_payment? ' - '.$object->num_payment : '';
print '</td></tr>';

// Amount
print '<tr><td>'.$langs->trans('Amount').'</td><td>'.price($object->amount, '', $langs, 0, -1, -1, $conf->currency).'</td></tr>';

$disable_delete = 0;
// Bank account
if (!empty($conf->banque->enabled))
{
	$bankline = new AccountLine($db);

	if ($object->fk_account > 0)
	{
		$bankline->fetch($object->bank_line);
		if ($bankline->rappro)
		{
			$disable_delete = 1;
			$title_button = dol_escape_htmltag($langs->transnoentitiesnoconv("CantRemoveConciliatedPayment"));
		}

		print '<tr>';
		print '<td>'.$langs->trans('BankAccount').'</td>';
		print '<td>';
		$accountstatic = new Account($db);
		$accountstatic->fetch($bankline->fk_account);
		print $accountstatic->getNomUrl(1);
		print '</td>';
		print '</tr>';
	}
}



// Bank account
if (!empty($conf->banque->enabled))
{
	
}

// Comments
print '<tr><td class="tdtop">'.$form->editfieldkey("Comments", 'note', $object->note, $object, $user->rights->facture->paiement).'</td><td>';
print $form->editfieldval("Note", 'note', $object->note, $object, $user->rights->facture->paiement, 'textarea:'.ROWS_3.':90%');
print '</td></tr>';

print '</table>';

print '</div>';

dol_fiche_end();


/*
 * List of invoices
 */

$sql = 'SELECT f.rowid as facid, f.ref, f.type, f.total_ttc, f.paye, f.fk_statut, pf.amount, s.nom as name, s.rowid as socid';
$sql .= ' FROM '.MAIN_DB_PREFIX.'paiement_facture as pf,'.MAIN_DB_PREFIX.'facture as f,'.MAIN_DB_PREFIX.'societe as s';
$sql .= ' WHERE pf.fk_facture = f.rowid';
$sql .= ' AND f.fk_soc = s.rowid';
$sql .= ' AND f.entity IN ('.getEntity('invoice').')';
$sql .= ' AND pf.fk_paiement = '.$object->id;
$resql = $db->query($sql);
if ($resql)
{
	$num = $db->num_rows($resql);

	$i = 0;
	$total = 0;

	$moreforfilter = '';

	print '<br>';

	print '<div class="div-table-responsive">';
	print '<table class="noborder centpercent">';

	print '<tr class="liste_titre">';
	print '<td>'.$langs->trans('Bill').'</td>';
	print '<td>'.$langs->trans('Company').'</td>';
	if ($conf->global->MULTICOMPANY_INVOICE_SHARING_ENABLED)print '<td>'.$langs->trans('Entity').'</td>';
	// print '<td class="right">'.$langs->trans('ExpectedToPay').'</td>';
    print '<td class="right">'.$langs->trans('PayedByThisPayment').'</td>';
    // print '<td class="right">'.$langs->trans('RemainderToPay').'</td>';
    // print '<td class="right">'.$langs->trans('Status').'</td>';
	print "</tr>\n";

	if ($num > 0)
	{
		while ($i < $num)
		{
			$objp = $db->fetch_object($resql);

			$thirdpartystatic->fetch($objp->socid);

			$invoice = new Facture($db);
			$invoice->fetch($objp->facid);

			$paiement = $invoice->getSommePaiement();
			$creditnotes = $invoice->getSumCreditNotesUsed();
			$deposits = $invoice->getSumDepositsUsed();
			$alreadypayed = price2num($paiement + $creditnotes + $deposits, 'MT');
			$remaintopay = price2num($invoice->total_ttc - $paiement - $creditnotes - $deposits, 'MT');

			print '<tr class="oddeven">';

            // Invoice
			print '<td>';
			print $invoice->getNomUrl(1);
			print "</td>\n";

			// Third party
			print '<td>';
			print $thirdpartystatic->getNomUrl(1);
			print '</td>';

			// Expected to pay
			// if ($conf->global->MULTICOMPANY_INVOICE_SHARING_ENABLED) {
				// print '<td>';
				// $mc->getInfo($objp->entity);
				// print $mc->label;
				// print '</td>';
			// }
			// Expected to pay
			// print '<td class="right">'.price($objp->total_ttc).'</td>';

            // Amount payed
            // print '<td class="right">'.price($objp->amount).'</td>';
			print '<td class="right" style="font-size: 24px;">'.price($objp->amount).'</td>';


            // Remain to pay
            // print '<td class="right">'.price($remaintopay).'</td>';

			// Status
			// print '<td class="right">'.$invoice->getLibStatut(5, $alreadypayed).'</td>';

			print "</tr>\n";
			if ($objp->paye == 1)	// If at least one invoice is paid, disable delete
			{
				$disable_delete = 1;
				$title_button = dol_escape_htmltag($langs->transnoentitiesnoconv("CantRemovePaymentWithOneInvoicePaid"));
			}
			$total = $total + $objp->amount;
			$i++;
		}
	}


	print "</table>\n";
	print '</div>';

	$db->free($resql);
}
else
{
	dol_print_error($db);
}



/*
 * Boutons Actions
 */



print '</div>';


// print '<button type="button" onclick="imprimirFormulario()">Imprimir</button>';
print '<button type="button" onclick="imprimirSeccion()">Imprimir</button>';

// End of page
llxFooter();
$db->close();

?>


</div>



<script>
function imprimirSeccion() {
  var contenido = document.getElementById('seccion_imprimir');
  window.print();
}

</script>
